// ConfigureOutputTZ.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "ConfigureOutputTZ.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigureOutputTZ dialog


CConfigureOutputTZ::CConfigureOutputTZ(CWnd* pParent /*=NULL*/)
: CDialog(CConfigureOutputTZ::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigureOutputTZ)
	m_ExistTZ = _T("");
	m_AcctName = _T("");
	m_PanelName = _T("");
	m_OutputName = _T("");
	m_ExistTZName = _T("");
	m_TimezoneName = _T("");
	m_iLockMode = 0;
	//}}AFX_DATA_INIT
}

CConfigureOutputTZ ::CConfigureOutputTZ(IApplication *pApp):CDialog(CConfigureOutputTZ::IDD, NULL)
{
	pApplication = pApp;
	m_ExistTZ = _T("");
	m_AcctName = _T("");
	m_PanelName = _T("");
	m_OutputName = _T("");
	m_ExistTZName = _T("");
	m_TimezoneName = _T("");
	m_iLockMode = 0;
}
void CConfigureOutputTZ::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			CString sAcctid;
			sAcctid.Format(L"%ld",pAccount->AccountID);
			m_AcctList.AddString(sAcctid);
			pAccount->Release();
		}
		pDisp->Release();
	}
	//	UpdateData(FALSE);
	//	m_AcctList.SetCurSel(0);
}
void CConfigureOutputTZ::LoadPanels()
{
	int index = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index,sAcctName);
	_variant_t vPanels;
	vPanels.Clear();
	long lAccountID = _wtoi(sAcctName);
	pApplication->GetPanelsByAcctID(lAccountID,&vPanels);
	if(vPanels.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No Panels");
		return;
	}
	
	long uBound =0 ;
	IHWDevice *pPanels =NULL;
	COleSafeArray sa(vPanels);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	//BSTR bstrPanel;
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pPanels);
		if (pPanels != NULL)
		{	
			CString sPanelid;
			sPanelid.Format(L"%ld",pPanels->HWDeviceID);
			m_PanelList.AddString(sPanelid);	
			pPanels->Release();
		}
		pDisp->Release();
	}
}
void CConfigureOutputTZ::LoadOutputs()
{
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(indexaccount,sAcctName);
	long lAccountID = _wtoi(sAcctName);
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	m_PanelList.GetLBText(indexpanel,sPanelID);
	_variant_t vOutputs;
	vOutputs.Clear();
	long lPanelID = _wtoi(sPanelID);
	pApplication->GetOutputsByPanelID(lAccountID,lPanelID,&vOutputs);
	if(vOutputs.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No Outputs");
		return;
	}
	
	long uBound =0 ;
	IHWDevice *pOutputs =NULL;
	COleSafeArray sa(vOutputs);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	//BSTR bstrPanel;
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pOutputs);
		if (pOutputs != NULL)
		{	
			CString sOutputid;
			sOutputid.Format(L"%ld",pOutputs->DeviceID);
			m_Outputs.AddString(sOutputid);	
			pOutputs->Release();
		}
		pDisp->Release();
	}
}
void CConfigureOutputTZ::LoadPanelTimezones()
{
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(indexaccount,sAcctName);
	long lAccountID = _wtoi(sAcctName);
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	m_PanelList.GetLBText(indexpanel,sPanelID);
	_variant_t vTimeZones;
	vTimeZones.Clear();
	long lPanelID = _wtoi(sPanelID);
	pApplication->GetAvailableTimezonesOfPanel(lAccountID,lPanelID,&vTimeZones);
	if(vTimeZones.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No Timezone");
		return;
	}
	int none = 0;
	CString sNone;
	sNone.Format(L"%d", none);
	m_Timezones.AddString(sNone);
	long uBound =0 ;
	ITimeZone *pTimeZones =NULL;
	COleSafeArray sa(vTimeZones);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	//BSTR bstrPanel;
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTimeZones);
		if (pTimeZones != NULL)
		{	
			CString sTimezoneid;
			sTimezoneid.Format(L"%ld",pTimeZones->TimeZoneID);
			m_Timezones.AddString(sTimezoneid);	
			pTimeZones->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}
void CConfigureOutputTZ::GetExistingTimezone()
{
	UpdateData(TRUE);
	
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(indexaccount,sAcctName);
	long lAccountID = _wtoi(sAcctName);
	
	
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	m_PanelList.GetLBText(indexpanel,sPanelID);
	long lPanelID = _wtoi(sPanelID);
	
	
	int indexoutput = m_Outputs.GetCurSel();
	CString sOutputID;
	m_Outputs.GetLBText(indexoutput,sOutputID);
	long lOutputID = _wtoi(sOutputID);
	
	_variant_t vTimeZone;
	vTimeZone.Clear();
	
	pApplication->GetAssociatedTimezoneOfOutputEx(lAccountID, lPanelID, lOutputID, m_iLockMode, &vTimeZone);
	
	if(vTimeZone.vt ==  VT_EMPTY)
	{
		return;
	}
	UpdateData(TRUE);
	if( vTimeZone.vt & VT_DISPATCH)
	{
		ITimeZonePtr pTz(vTimeZone.pdispVal);
		long lTimezoneID = pTz->TimeZoneID;
		CString sTimezoneid;
		BSTR pBstrTimezoneName;
		sTimezoneid.Format(L"%ld",lTimezoneID);
		m_ExistTZ = sTimezoneid;
		pApplication->GetTimezoneNameByID(lTimezoneID,&pBstrTimezoneName);
		
		if(lTimezoneID==0)
		{
			m_ExistTZName = "None";
		}
		else 
		{
			m_ExistTZName = CString(pBstrTimezoneName);	
		}
		
	}
	UpdateData(FALSE);
	
	if(NULL != vTimeZone.pdispVal)
	{
		//vTz.pdispVal->Release();
		vTimeZone.Clear();
	}
	
}
void CConfigureOutputTZ::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigureOutputTZ)
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Text(pDX, IDC_ACCTNAME, m_AcctName);
	DDX_Control(pDX, IDC_PANELLIST, m_PanelList);
	DDX_Text(pDX, IDC_PANELNAME, m_PanelName);
	DDX_Control(pDX, IDC_OUTPUTS, m_Outputs);
	DDX_Text(pDX, IDC_OUTPUTNAME, m_OutputName);
	DDX_Control(pDX, IDC_TIMEZONES, m_Timezones);
	DDX_Text(pDX, IDC_TIMEZONENAME, m_TimezoneName);
	DDX_Text(pDX, IDC_EXISTINGTIMEZONE, m_ExistTZ);
	DDX_Text(pDX, IDC_EXISTTZNAME, m_ExistTZName);
	// Adding the new Lock Modes Lock/Unlock for setting the Output TZ, WNAPI-431 -- Guru
	DDX_Radio(pDX, IDC_LOCKMODE, m_iLockMode);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigureOutputTZ, CDialog)
//{{AFX_MSG_MAP(CConfigureOutputTZ)
	ON_WM_CANCELMODE()
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_PANELLIST, OnSelchangePanellist)
	ON_BN_CLICKED(IDC_CONFIGURE, OnConfigure)
	ON_CBN_SELCHANGE(IDC_OUTPUTS, OnSelchangeOutputs)
	ON_CBN_SELCHANGE(IDC_TIMEZONES, OnSelchangeTimezones)
	ON_BN_CLICKED(IDC_LOCKMODE, OnChangeLockmode)
	ON_BN_CLICKED(IDC_LOCKMODE2, OnChangeLockmode)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigureOutputTZ message handlers

BOOL CConfigureOutputTZ::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigureOutputTZ::OnCancelMode() 
{
	CDialog::OnCancelMode();
	
	// TODO: Add your message handler code here
	
}

void CConfigureOutputTZ::OnSelchangeAcctlist() 
{
	m_PanelList.ResetContent();
	m_Timezones.ResetContent();
	m_Outputs.ResetContent();
	CString sAcctName;
	BSTR pBstrAcctName;
	long lAccountID;
	int indexaccount = 0;
	indexaccount = m_AcctList.GetCurSel();
	if(indexaccount<0)
	{
		lAccountID = 0;
	}
	else
	{
		m_AcctList.GetLBText(indexaccount,sAcctName);
		lAccountID = _wtoi(sAcctName);
	}
	pApplication->GetAccountNameByAcctID(lAccountID,&pBstrAcctName);
	UpdateData(TRUE);
	m_AcctName = CString(pBstrAcctName);
	UpdateData(FALSE);
	LoadPanels();	
}

void CConfigureOutputTZ::OnSelchangePanellist() 
{
	m_Outputs.ResetContent();
	LoadOutputs();
	m_Timezones.ResetContent();
	LoadPanelTimezones();
	BSTR pBstrDeviceName;
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	long lHWDeviceID;
	if(indexpanel<0)
	{
		lHWDeviceID = 0;
	}
	else
	{
		m_PanelList.GetLBText(indexpanel,sPanelID);
		lHWDeviceID = _wtoi(sPanelID);
	}
	pApplication->GetDeviceNameByHWDeviceID(lHWDeviceID,&pBstrDeviceName);
	UpdateData(TRUE);
	m_PanelName = CString(pBstrDeviceName);
	UpdateData(FALSE);
	
}

void CConfigureOutputTZ::OnConfigure() 
{
	UpdateData(TRUE);
	int indexaccount = m_AcctList.GetCurSel();
	CString sAcctName;
	long lAccountID = 0;
	if(indexaccount<0)
	{
		lAccountID = 0;
	}
	else
	{
		m_AcctList.GetLBText(indexaccount,sAcctName);
		lAccountID = _wtoi(sAcctName);
	}
	
	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	long lPanelID=0;
	if(indexpanel<0)
	{
		lPanelID = 0;
	}
	else
	{
		m_PanelList.GetLBText(indexpanel,sPanelID);
		lPanelID = _wtoi(sPanelID);
	}
	
	int indexoutput = m_Outputs.GetCurSel();
	CString sOutputID ;
	long lOutputID =0;
	if(indexoutput<0)
	{
		lOutputID = 0;
	}
	else
	{
		m_Outputs.GetLBText(indexoutput,sOutputID);
		lOutputID = _wtoi(sOutputID);
	}
	
	int indextimezone = m_Timezones.GetCurSel();
	CString sTimezoneID;
	long lTimezoneID = 0;
	if(indextimezone<0)
	{
		lTimezoneID= -1;
	}
	else
	{
		m_Timezones.GetLBText(indextimezone,sTimezoneID);
		lTimezoneID =_wtoi(sTimezoneID);
	}
	long lStatus =0;
	pApplication->ConfigureOutputTimezoneEx(lAccountID,lPanelID,lOutputID,m_iLockMode,lTimezoneID,&lStatus);	
	if ( lStatus == 0)
	{
		AfxMessageBox(L"Timezone configured Successfully");
		CDialog::OnOK();
	}
	else if (lStatus == 1)
	{
		AfxMessageBox(L"Timezone configuration failed");
		CDialog::OnOK();
	}
	else if (lStatus == 105)
	{
		AfxMessageBox(L"Invalid account");
		return;
	}
	else if (lStatus == 501)
	{
		AfxMessageBox(L"Invalid panel");
		return;
	}
	else if (lStatus == 502)
	{
		AfxMessageBox(L"Invalid output");
		return;
	}
	else if (lStatus == 504)
	{
		AfxMessageBox(L"Invalid timezone");
		return;
	}
	else if (lStatus == 515)
	{
		AfxMessageBox(L"Invalid Lock/Unlock Mode");
		return;
	}
}

void CConfigureOutputTZ::OnSelchangeOutputs() 
{
	BSTR pBstrDeviceName;
	m_ExistTZ = _T("0");
	m_ExistTZName = "";
	int indexoutput = m_Outputs.GetCurSel();
	CString sOutputID;
	long lDeviceID;
	if(indexoutput<0)
	{
		lDeviceID = 0;
	}
	else
	{
		m_Outputs.GetLBText(indexoutput,sOutputID);
		lDeviceID = _wtoi(sOutputID);
	}
	pApplication->GetDevNameByDeviceID(lDeviceID,&pBstrDeviceName);
	UpdateData(TRUE);
	m_OutputName = CString(pBstrDeviceName);
	UpdateData(FALSE);
	m_ExistTZ = _T("0");
	// For the UI Update on the None TZ Issue -- Guru
	m_ExistTZName = _T("None");
	UpdateData(FALSE);
	GetExistingTimezone();	
}

void CConfigureOutputTZ::OnSelchangeTimezones() 
{
	BSTR pBstrTimezoneName;
	int indextimezone = m_Timezones.GetCurSel();
	CString sTimezoneID;
	long lTimezoneID;
	if(indextimezone<0)
	{
		lTimezoneID= 0;
	}
	else
	{
		m_Timezones.GetLBText(indextimezone,sTimezoneID);
		lTimezoneID = _wtoi(sTimezoneID);
	}
	pApplication->GetTimezoneNameByID(lTimezoneID,&pBstrTimezoneName);
	UpdateData(TRUE);
	if(lTimezoneID==0)
	{
		pBstrTimezoneName = SysAllocString(L"None");
	}
	m_TimezoneName = CString(pBstrTimezoneName);
	UpdateData(FALSE);
}

void CConfigureOutputTZ::OnChangeLockmode() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	GetExistingTimezone();
}
